//
//  BIDatabaseUpgrader.h
//  BISubstrate
//
//  Created by Eric Hochmeister on 16/08/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import "BIDatabaseConnection.h"

@class BIDatabaseObjectContext;
@class BIConsolidatedTax;
@class BITax;
@class BIExtraFieldNames;

/*!
    @class       BIDatabaseUpgrader
    @abstract    BIDatabaseUpgrader is a class which is responsible for handling schema changes requiring objective-c code in order to perform the logic for the schema change.  
    @discussion  The methods in this class are called usually from an mcupdate script when we are performing an update to the database when migrating between Billings versions.  an example of calling a method from the mcupdate script is, MCObjcCommand(BIDatabaseUpgrader, migrate1xTaxesTo2x);
*/


@interface BIDatabaseUpgrader : NSObject {

    BIDatabaseConnection* connection; 
    
}

- (id)initWithDatabaseConnection:(BIDatabaseConnection *)conn;

- (void)migrate1xTaxesTo2x;

- (BIConsolidatedTax*)createConsolidatedTaxWithPrimary:(BITax*)primTax
                                             secondary:(BITax*)secTax
                                         objectContext:(BIDatabaseObjectContext*)objectContext;

- (void)resolveDatabaseEntityLinksToNewTax:(BIConsolidatedTax*)consTax 
                        usingObjectContext:(BIDatabaseObjectContext*)oc
                                primaryTax:(BIConsolidatedTax*)primConsTax
                              secondaryTax:(BIConsolidatedTax*)secConsTax
                                primSecTax:(BIConsolidatedTax*)primSecConsTax;

- (void)resolveTaxSettingsForSlipTemplatesUsingObjectContext:(BIDatabaseObjectContext*)objectContext
                                                  primaryTax:(BIConsolidatedTax*)primConsTax
                                                secondaryTax:(BIConsolidatedTax*)secConsTax
                                                  primSecTax:(BIConsolidatedTax*)primSecConsTax;

- (void)resolveLinksToNewTaxForEntityNamed:(NSString*)entityName
                        usingObjectContext:(BIDatabaseObjectContext*)oc
                                primaryTax:(BIConsolidatedTax*)primConsTax
                              secondaryTax:(BIConsolidatedTax*)secConsTax
                                primSecTax:(BIConsolidatedTax*)primSecConsTax;

- (BIConsolidatedTax*)matchTaxesOfObject:(id)anObj
                       againstPrimaryTax:(BIConsolidatedTax*)primConsTax
                            secondaryTax:(BIConsolidatedTax*)secConsTax
                              primSecTax:(BIConsolidatedTax*)primSecTax;

- (BOOL)primaryTaxOfObject:(id)anObj
                matchesTax:(BIConsolidatedTax*)primConsTax;

- (BOOL)secondaryTaxOfObject:(id)anObj
                  matchesTax:(BIConsolidatedTax*)secConsTax;

- (BITax*)createNewPrimaryTaxForObject:(id)anObj;
- (BITax*)createNewSecondaryTaxForObject:(id)anObj;

- (void)createNewConsolidatedPrimaryTaxForObject:(id)anObj;
- (void)createNewConsolidatedSecondaryTaxForObject:(id)anObj;

- (void)createNewConsolidatedTaxForObject:(id)anObj
                               primaryTax:(BITax*)primTax
                             secondaryTax:(BITax*)secTax;

- (void)resolveTaxConflictForObject:(id)anObj 
                     primaryMatches:(BOOL)primMatches 
                         primaryTax:(BIConsolidatedTax*)primConsTax
                   secondaryMatches:(BOOL)secMatches
                       secondaryTax:(BIConsolidatedTax*)secConsTax;

- (void)populateExtraFieldNamesForClientEntity;
- (void)ensureExtraFieldNamesForClientEntityPopulated;
- (BIExtraFieldNames*)generateExtraFieldNamesForClient;

- (void)ensureNameOnUserIsSet;
- (void)convertForeignAppUserToUser;

- (void)removeDuplicateClients;

- (void)fixMeClientAndPrimaryUser;
- (void)relinkClientsAndCacheData;

@end
